<form class="wpzinc-tinymce-popup">
    <div class="option">
        <div class="left">
            <strong><?php _e( 'Group', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="group_id" data-shortcode="group_id" size="1">
                <option value=""><?php _e( 'This Group', 'page-generator-pro' ); ?></option>
                <?php
                foreach ( Page_Generator_Pro_Groups::get_instance()->get_all_ids_names() as $group_id => $group_name ) {
                    ?>
                    <option value="<?php echo $group_id; ?>">- <?php echo $group_name; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Number of Links', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <input type="number" name="limit" data-shortcode="limit" value="5" min="0" max="9999999" step="1" placeholder="<?php _e( 'e.g. 5', 'page-generator-pro' ); ?>" class="widefat" />
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Post Type', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="post_type" data-shortcode="post_type" size="1">
                <option value=""><?php _e( '(all)', 'page-generator-pro' ); ?></option>
                <?php
                foreach ( Page_Generator_Pro_Common::get_instance()->get_post_types() as $post_type ) {
                    ?>
                    <option value="<?php echo $post_type->name; ?>"><?php echo $post_type->label; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Post Status', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="post_status" data-shortcode="post_status" size="1">
                <?php
                foreach ( Page_Generator_Pro_Common::get_instance()->get_post_statuses() as $post_status => $post_status_label ) {
                    ?>
                    <option value="<?php echo $post_status; ?>" <?php selected( $post_status, 'publish' ); ?>><?php echo $post_status_label; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Post Author', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="author" data-shortcode="author" size="1">
                <option value=""><?php _e( '(any)', 'page-generator-pro' ); ?></option>
                <?php
                foreach ( Page_Generator_Pro_Common::get_instance()->get_authors() as $author ) {
                    ?>
                    <option value="<?php echo $author->ID; ?>"><?php echo $author->user_login; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Order Links By', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="orderby" data-shortcode="orderby" size="1">
                <?php
                foreach ( Page_Generator_Pro_Common::get_instance()->get_order_by_options() as $key => $label ) {
                    ?>
                    <option value="<?php echo $key; ?>"><?php echo $label; ?></option>
                    <?php
                }
                ?>
            </select>
            <select name="order" data-shortcode="order" size="1">
                <?php
                foreach ( Page_Generator_Pro_Common::get_instance()->get_order_options() as $key => $label ) {
                    ?>
                    <option value="<?php echo $key; ?>"><?php echo $label; ?></option>
                    <?php
                }
                ?>
            </select>
        </div>
    </div>

    <div class="option buttons">
        <div class="left">
            <button type="button" class="close button"><?php _e( 'Cancel', 'page-generator-pro' ); ?></button>
        </div>
        <div class="right">
            <input type="hidden" name="shortcode" value="page-generator-pro-related-links" />
            <input name="submit" type="submit" value="<?php _e( 'Insert', 'page-generator-pro' ); ?>" class="button button-primary right" />
        </div>
    </div>
</form>