<form class="wpzinc-tinymce-popup">
    <div class="option">
        <div class="left">
            <strong><?php _e( 'Term', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <input type="text" name="term" data-shortcode="term" value="" placeholder="<?php _e( 'e.g. restaurants', 'page-generator-pro' ); ?>" class="widefat" />

            <p class="description">
                <?php _e( 'Optional: If defined, will plot all items (e.g. businesses) matching the Term and Location', 'page-generator-pro' ); ?>
            </p>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Location', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <input type="text" name="location" data-shortcode="location" value="" placeholder="<?php _e( 'e.g. Birmingham, UK', 'page-generator-pro' ); ?>" class="widefat" required />
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Height', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <input type="number" name="height" data-shortcode="height" min="1" max="9999" step="1" value="250" required />px
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Zoom Level', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="zoom" data-shortcode="zoom" size="1">
                <?php
                for ( $i = 1; $i <= 20; $i++ ) {
                    ?>
                    <option value="<?php echo $i; ?>"<?php selected( 14, $i, true ); ?>><?php echo $i; ?></option>
                    <?php
                }
                ?>
            </select>
            <p class="description">
                <?php _e( 'A higher number means a higher zoom level, showing more detail. As a guide, 1 = World; 20 = Buildings', 'page-generator-pro' ); ?>
            </p>
        </div>
    </div>

    <div class="option">
        <div class="left">
            <strong><?php _e( 'Map Type', 'page-generator-pro' ); ?></strong>
        </div>
        <div class="right">
            <select name="maptype" data-shortcode="maptype" size="1">
                <option value="roadmap" selected><?php _e( 'Road Map', 'page-generator-pro' ); ?></option>
                <option value="satellite"><?php _e( 'Satellite', 'page-generator-pro' ); ?></option>
            </select>
        </div>
    </div>

    <div class="option buttons">
        <div class="left">
            <button type="button" class="close button"><?php _e( 'Cancel', 'page-generator-pro' ); ?></button>
        </div>
        <div class="right">
            <input type="hidden" name="shortcode" value="page-generator-pro-google-map" />
            <input name="submit" type="submit" value="<?php _e( 'Insert', 'page-generator-pro' ); ?>" class="button button-primary right" />
        </div>
    </div>
</form>