<div class="wrap">
    <h1 class="wp-heading-inline">
        <?php echo $this->base->plugin->displayName; ?>

        <span>
            <?php _e( 'Keywords', $this->base->plugin->name ); ?>
        </span>
    </h1>

    <?php
    // Button Links
    require_once( 'keywords-links.php' );

    // Search Subtitle
    if ( isset( $_REQUEST['s'] ) && ! empty( $_REQUEST['s'] ) ) {
        ?>
        <span class="subtitle"><?php _e( 'Search results for', $this->base->plugin->name ); ?> &#8220;<?php echo urldecode( $_REQUEST['s'] ); ?>&#8221;</span>
        <?php
    }
    ?>

    <?php
    // Notices
    foreach ( $this->notices as $type => $notices_type ) {
        if ( count( $notices_type ) == 0 ) {
            continue;
        }
        ?>
        <div class="<?php echo ( ( $type == 'success' ) ? 'updated' : $type ); ?> notice">
            <?php
            foreach ( $notices_type as $notice ) {
                ?>
                <p><?php echo $notice; ?></p>
                <?php
            }
            ?>
        </div>
        <?php
    }
    ?>

	<form action="admin.php?page=<?php echo $page; ?>" method="post" id="posts-filter">
		<p class="search-box">
	    	<label class="screen-reader-text" for="post-search-input"><?php _e(' Search Keywords', $this->base->plugin->name ); ?>:</label>
	    	<input type="text" id="field-search-input" name="s" value="<?php echo ( isset( $_REQUEST['s'] ) ? $_REQUEST['s'] : ''); ?>" />
	    	<input type="submit" name="search" class="button" value="<?php _e( 'Search Keywords', $this->base->plugin->name ); ?>" />
	    </p>
	    
		<?php   
		// Output WP_List_Table
		$keywords_table = new Page_Generator_Pro_Keywords_Table();
		$keywords_table->prepare_items();
		$keywords_table->display(); 
		?>	
	</form>

</div><!-- /.wrap -->