<div class="wrap">
    <h1 class="wp-heading-inline">
        <?php echo $this->base->plugin->displayName; ?>

        <span>
        	<?php
        	if ( isset( $keyword ) && isset( $keyword['keywordID'] ) ) {
        		_e( 'Edit Keyword', $this->base->plugin->name );
        	} else {
        		_e( 'Add New Keyword', $this->base->plugin->name );
        	}
        	?>
        </span>
    </h1>

    <?php
    // Button Links
    require_once( 'keywords-links.php' );

    // Notices
    foreach ( $this->notices as $type => $notices_type ) {
        if ( count( $notices_type ) == 0 ) {
            continue;
        }
        ?>
        <div class="<?php echo ( ( $type == 'success' ) ? 'updated' : $type ); ?> notice">
            <?php
            foreach ( $notices_type as $notice ) {
                ?>
                <p><?php echo $notice; ?></p>
                <?php
            }
            ?>
        </div>
        <?php
    }
    ?>
    
    <div class="wrap-inner">
	    <div id="poststuff">
	    	<div id="post-body" class="metabox-holder columns-1">
	    		<!-- Content -->
	    		<div id="post-body-content">
	    			<!-- Form Start -->
	    			<form class="<?php echo $this->base->plugin->name; ?>" name="post" method="post" action="admin.php?page=<?php echo $page; ?>&amp;cmd=form<?php echo ( isset( $_GET['id'] ) ? '&id=' . absint( $_GET['id'] ) : '' ); ?>" enctype="multipart/form-data">		
		    	    	<div id="normal-sortables" class="meta-box-sortables ui-sortable">                        
			                <div id="keyword-panel" class="postbox">
			                    <h3 class="hndle"><?php _e( 'Keyword', $this->base->plugin->name ); ?></h3>
			                    <input type="hidden" name="id" id="id" value="<?php echo ( ( isset( $keyword ) && isset( $keyword['keywordID'] ) ) ? $keyword['keywordID'] : '' ); ?>" />
		
			                    <div class="option">
			                    	<div class="left">
			                    		<strong><?php _e( 'Keyword', $this->base->plugin->name ); ?></strong>
			                    	</div>
			                    	<div class="right">
			                    		<input type="text" name="keyword" value="<?php echo ( isset( $keyword['keyword'] ) ? $keyword['keyword'] : '' ); ?>" class="widefat" />
			                    	
				                    	<p class="description">
				                    		<?php _e( 'A unique template tag name, which can then be used when generating content.', $this->base->plugin->name ); ?>
				                    	</p>
			                    	</div>
			                    </div>
			                    
			                    <div class="option">
			                    	<div class="full">
			                    		<strong><?php _e( 'Terms', $this->base->plugin->name ); ?></strong>
			                    	</div>
			                    	<div class="full">
			                    		<textarea name="data" rows="10" class="widefat" style="height:300px"><?php echo ( isset( $keyword['data'] ) ? $keyword['data'] : '' ); ?></textarea>
			                    	
				                    	<p class="description">
				                    		<?php _e( 'Word(s) or phrase(s) which will be cycled through when generating content using the above keyword template tag.', $this->base->plugin->name ); ?>
				                    		<br />
				                    		<?php _e( 'One word / phase per line.', $this->base->plugin->name ); ?>
				                    		<br />
				                    		<?php _e( 'If no Terms are entered, the plugin will try to automatically determine a list of similar terms based on the supplied keyword when you click Save.', $this->base->plugin->name ); ?>
				                    	</p>
			                    	</div>
			                    </div>
			                    
			                    <div class="option">
			                    	<div class="left">
			                    		<strong><?php _e( 'Data Import', $this->base->plugin->name ); ?></strong>
			                    	</div>
			                    	<div class="right">
			                    		<input type="file" name="file" />
			                    	
				                    	<p class="description">
				                    		<?php _e( 'To mass import data, upload either a CSV file (format word1,word2,word3) or TXT file (one word / phrase per line).', $this->base->plugin->name ); ?>
											<br />
											<?php _e( 'This will append the imported words / phrases to the above Keyword Data.', $this->base->plugin->name ); ?>
				                    	</p>
			                    	</div>
			                    </div>
			                    
			                    <div class="option">
		                    		<?php wp_nonce_field( 'save_keyword', $this->base->plugin->name . '_nonce' ); ?>
		                			<input type="submit" name="submit" value="<?php _e( 'Save', $this->base->plugin->name ); ?>" class="button button-primary" />
			                    </div>
			                </div>
						</div>
						<!-- /normal-sortables -->
				    </form>
				    <!-- /form end -->
	    		</div>
	    		<!-- /post-body-content -->
	    	</div>
		</div>  
	</div>     
</div>