<div class="wrap">
    <h1 class="wp-heading-inline">
        <?php echo $this->base->plugin->displayName; ?>

        <span>
            <?php echo sprintf( __( 'Generating &quot;%s&quot;', $this->base->plugin->name ), $settings['title'] ); ?>
        </span>
    </h1>

    <hr class="wp-header-end" />

    <div class="wrap-inner">
        <p>
        	<?php 
            _e( 'Please be patient while content is generated. This can take a while if you have a lot of Pages to generate,
                and/or you are using Page Generator Shortcodes.
                <a href="https://www.wpzinc.com/documentation/page-generator-pro/generate/#page-generation" target="_blank">Read the Documentation</a> to understand why.', $this->base->plugin->name );
            ?>
            <br />

        	<?php _e( 'Do not navigate away from this page until this script is done or all items will not be generated.
        	You will be notified via this page when the process is completed.', $this->base->plugin->name ); ?>
        </p>

        <!-- Progress Bar -->
        <div id="progress-bar"></div>
        <div id="progress">
            <span id="progress-number">0</span>
            <span> / <?php echo $settings['numberOfPosts']; ?></span>
        </div>

        <!-- Status Updates -->
        <div id="log">
            <ul></ul>
        </div>

        <p>
            <!-- Cancel Button -->
            <a href="post.php?post=<?php echo $id; ?>&amp;action=edit" class="button button-red page-generator-pro-generate-cancel-button">
                <?php _e( 'Stop Generation', $this->base->plugin->name ); ?>
            </a>

            <!-- Return Button (display when generation routine finishes -->
            <a href="<?php echo $return_url; ?>" class="button button-primary page-generator-pro-generate-return-button">
                <?php _e( 'Return to Group', $this->base->plugin->name ); ?>
            </a>
        </p>
    </div>

    <!-- Triggers AJAX request to run numberOfPosts -->
    <script type="text/javascript">
        jQuery( document ).ready( function( $ ) {

            var page_generator_pro_cancelled = false;
            
            $('#progress-bar').synchronous_request( {
                url:                ajaxurl,
                number_requests:    <?php echo $settings['numberOfPosts'] + $settings['resumeIndex']; ?>,
                offset:             <?php echo $settings['resumeIndex']; ?>,
                data: {
                    id:     <?php echo $id; ?>,
                    action: 'page_generator_pro_generate_<?php echo $type; ?>'   
                },
                onRequestSuccess: function( response, currentIndex ) {

                    // Update counter
                    $( '#progress-number' ).text( ( currentIndex + 1 ) );

                    if ( response.success ) {
                        var message = 'Created <a href="' + response.data.url + '" target="_blank">' + response.data.url + '</a> in ' + response.data.duration + ' seconds.  Memory Usage / Peak: ' + response.data.memory_usage + '/' + response.data.memory_peak_usage + 'MB';
                        for ( var keyword in response.data.keywords_terms ) {
                            message += '<br />{' + keyword + '}: ' + response.data.keywords_terms[ keyword ];
                        }

                        $( '#log ul' ).append( '<li>' + message + '</li>' );

                        // Run the next request, unless the user clicked the 'Stop Generation' button
                        if ( page_generator_pro_cancelled == true ) {
                            this.onFinished();
                            return false;
                        }

                        // Run the next request
                        return true;
                    } else {
                        // Something went wrong
                        $( '#log ul' ).append( '<li class="error">' + response.data + '</a></li>' ); 

                        // Don't run any more requests
                        return false;
                    }

                },

                onRequestError: function( xhr, textStatus, e, currentIndex ) {

                    console.log(xhr);
                    console.log(textStatus);
                    console.log(e);

                    // Update counter
                    $( '#progress-number' ).text( ( currentIndex + 1 ) );

                    $( '#log ul' ).append( '<li class="error">' + xhr.status + ' ' + xhr.statusText + '</li>' );

                    // Hide the 'Stop Generation' button
                    $( 'a.page-generator-pro-generate-cancel-button' ).hide();

                    // Show the 'Return to Group' button
                    $( 'a.page-generator-pro-generate-return-button' ).removeClass( 'page-generator-pro-generate-return-button' );

                    // Don't run any more requests
                    return false;

                },

                onFinished: function() {

                    // If the user clicked the 'Stop Generation' button, show that in the log.
                    if ( page_generator_pro_cancelled == true ) {
                        $( '#log ul' ).append( '<li>Process cancelled by user</li>' );
                    } else {
                        $( '#log ul' ).append( '<li>Finished</li>' );
                    }

                    // Hide the 'Stop Generation' button
                    $( 'a.page-generator-pro-generate-cancel-button' ).hide();

                    // Show the 'Return to Group' button
                    $( 'a.page-generator-pro-generate-return-button' ).removeClass( 'page-generator-pro-generate-return-button' );

                }
            } );

            // Sets the page_generator_pro_cancelled flag to true when the user clicks the 'Stop Generation' button
            $( 'a.page-generator-pro-generate-cancel-button' ).on( 'click', function( e ) {
                e.preventDefault();
                page_generator_pro_cancelled = true;
            } );
        } );  
    </script>
</div>