 <div class="option">
	<div class="left">
		<strong><?php _e( 'Method', $this->base->plugin->name ); ?></strong>
	</div>
	<div class="right">
		<select name="<?php echo $this->base->plugin->name; ?>[method]" size="1">
			<?php
			if ( is_array( $methods ) && count( $methods ) > 0 ) {
				foreach ( $methods as $method => $label ) {
					?>
					<option value="<?php echo $method; ?>"<?php selected( $this->settings['method'], $method ); ?>>
						<?php echo $label; ?>
					</option>
					<?php
				}
			}
			?>
		</select>
	</div>
	<p class="description">
		<?php echo sprintf( __( '<strong>All:</strong> Generates %s for all possible combinations of terms across all keywords used.', $this->base->plugin->name ), $labels['plural'] ); ?>
	</p>
	<p class="description">
		<?php _e( '<strong>Sequential:</strong> Honors the order of terms in each keyword used. Once all terms have been used in a keyword, the generator stops.', $this->base->plugin->name ); ?>
	</p>
	<p class="description">
		<?php echo sprintf( __( '<strong>Random:</strong> For each %s generated, selects a term at random from each keyword used.', $this->base->plugin->name ), $labels['singular'] ); ?>
	</p>
</div>

<div class="option">
	<div class="left">
		<strong><?php _e( 'Overwrite', $this->base->plugin->name ); ?></strong>
	</div>
	<div class="right">
		<select name="<?php echo $this->base->plugin->name; ?>[overwrite]" size="1">
			<?php
			if ( is_array( $overwrite_methods ) && count( $overwrite_methods ) > 0 ) {
				foreach ( $overwrite_methods as $method => $label ) {
					?>
					<option value="<?php echo $method; ?>"<?php selected( $this->settings['overwrite'], $method ); ?>>
						<?php echo $label; ?>
					</option>
					<?php
				}
			}
			?>
		</select>
	</div>
	<p class="description">
		<?php echo sprintf( __( 'If enabled, and an existing %s is found matching the Permalink that was generated by this Plugin, that %s will be overwritten.  Using the preseve Publish Date option will not change the date of the generated %s.', $this->base->plugin->name ), $labels['singular'], $labels['singular'], $labels['singular'] ); ?>
	</p>
</div>

<div class="option">
	<div class="left">
		<strong><?php echo sprintf( __( 'No. %s', $this->base->plugin->name ), $labels['plural'] ); ?></strong>
	</div>
	<div class="right">
		<input type="number" name="<?php echo $this->base->plugin->name; ?>[numberOfPosts]" value="<?php echo $this->settings['numberOfPosts']; ?>" step="1" min="0" class="widefat" />
	</div>
	<p class="description">
		<?php echo sprintf( __( 'The number of %s to generate. If zero or blank, all %s will be generated.', $this->base->plugin->name ), $labels['plural'], $labels['plural'] ); ?>
	</p>
</div>

<div class="option">
	<div class="left">
		<strong><?php _e( 'Resume Index', $this->base->plugin->name ); ?></strong>
	</div>
	<div class="right">
		<input type="number" name="<?php echo $this->base->plugin->name; ?>[resumeIndex]" value="<?php echo $this->settings['resumeIndex']; ?>" step="1" min="0" class="widefat" />
	</div>
	<p class="description">
		<?php _e( 'Optional: If generation did not fully complete (e.g. 50 / 100 only), or you specified a limit, you can set the Resume Index = 50.', $this->base->plugin->name ); ?>
	</p>
</div>