<?php
/**
* Plugin Name: Page Generator Pro
* Plugin URI: http://www.wpzinc.com/plugins/page-generator-pro
* Version: 1.7.7
* Author: WP Zinc
* Author URI: http://www.wpzinc.com
* Description: Generate multiple Pages, Posts and Custom Post Types, using dynamic content selected from a number of sources.
*/

/**
 * Page Generator Pro Class
 * 
 * @package   Page_Generator_Pro
 * @author    Tim Carr
 * @version   1.0.0
 * @copyright WP Zinc
 */
class Page_Generator_Pro {

    /**
     * Holds the class object.
     *
     * @since   1.1.3
     *
     * @var     object
     */
    public static $instance;

    /**
     * Holds the plugin information object.
     *
     * @since   1.0.0
     *
     * @var     object
     */
    public $plugin = '';

    /**
     * Holds the dashboard class object.
     *
     * @since   1.1.6
     *
     * @var     object
     */
    public $dashboard = '';

    /**
     * Holds the licensing class object.
     *
     * @since   1.1.6
     *
     * @var     object
     */
    public $licensing = '';

    /**
     * Constructor. Acts as a bootstrap to load the rest of the plugin
     * 
     * @since 1.0.0
     */
    public function __construct() {

        // Bail if the Free version of the Plugin is active
        if ( class_exists( 'Page_Generator' ) ) {
            return;
        }

        // Plugin Details
        $this->plugin = new stdClass;
        $this->plugin->name         = 'page-generator-pro';
        $this->plugin->displayName  = 'Page Generator Pro';
        $this->plugin->version      = '1.7.7';
        $this->plugin->buildDate    = '2018-09-13 18:00:00';
        $this->plugin->requires     = 3.6;
        $this->plugin->tested       = '4.9.8';
        $this->plugin->folder       = plugin_dir_path( __FILE__ );
        $this->plugin->url          = plugin_dir_url( __FILE__ );
        $this->plugin->documentation_url= 'https://www.wpzinc.com/documentation/page-generator-pro';
        $this->plugin->support_url      = 'https://www.wpzinc.com/support';
        $this->plugin->upgrade_url      = 'https://www.wpzinc.com/plugins/page-generator-pro';
        $this->plugin->review_name      = 'page-generator';
        $this->plugin->review_notice    = sprintf( __( 'Thanks for using %s to generate content!', $this->plugin->name ), $this->plugin->displayName );

        // Dashboard Submodule
        if ( ! class_exists( 'WPZincDashboardWidget' ) ) {
            require_once( $this->plugin->folder . '_modules/dashboard/dashboard.php' );
        }
        $this->dashboard = new WPZincDashboardWidget( $this->plugin );

        // Licensing Submodule
        if ( ! class_exists( 'LicensingUpdateManager' ) ) {
            require_once( $this->plugin->folder . '_modules/licensing/lum.php' );
        }
        $this->licensing = new LicensingUpdateManager( $this->plugin, 'http://www.wpzinc.com/wp-content/plugins/lum', $this->plugin->name );

        // Admin
        if ( is_admin() ) {
            // Required class
            require_once( $this->plugin->folder . 'includes/admin/admin.php' );
            require_once( $this->plugin->folder . 'includes/admin/geo.php' );
            require_once( $this->plugin->folder . 'includes/admin/install.php' );
            require_once( $this->plugin->folder . 'includes/admin/groups.php' );
            require_once( $this->plugin->folder . 'includes/admin/groups-terms.php' );
            require_once( $this->plugin->folder . 'includes/admin/keywords.php' );

            // Init non-static classes
            add_action( 'admin_init', array( $this, 'deactivate_free_version' ) );
            add_action( 'init', array( $this, 'upgrade' ) );

            // Licensed
            if ( $this->licensing->check_license_key_valid() ) {
                // Load licensed files
                require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
                require_once( $this->plugin->folder . 'includes/admin/ajax.php' );
                require_once( $this->plugin->folder . 'includes/admin/common.php' );
                require_once( $this->plugin->folder . 'includes/admin/generate.php' );
                require_once( $this->plugin->folder . 'includes/admin/geonames.php' );
                require_once( $this->plugin->folder . 'includes/admin/import.php' );
                require_once( $this->plugin->folder . 'includes/admin/keywords-table.php' );
                require_once( $this->plugin->folder . 'includes/admin/spintax.php' );
                require_once( $this->plugin->folder . 'includes/admin/webanalyzer.php' );
                require_once( $this->plugin->folder . 'includes/admin/youtube.php' );
                require_once( $this->plugin->folder . 'includes/admin/yelp.php' );
            }
        }
 
        // Global
        require_once( $this->plugin->folder . 'includes/global/posttype.php' );
        require_once( $this->plugin->folder . 'includes/global/settings.php' );
        require_once( $this->plugin->folder . 'includes/global/taxonomy.php' );

        if ( $this->licensing->check_license_key_valid() ) {
            require_once( $this->plugin->folder . 'includes/global/editor.php' );
            require_once( $this->plugin->folder . 'includes/global/pagebuilders.php' );
            require_once( $this->plugin->folder . 'includes/global/shortcode.php' );
            
            // Load WP-CLI classes, if WP-CLI exists
            if ( class_exists( 'WP_CLI' ) ) {
                // In CLI mode, is_admin() is not called, so we need to require the classes that
                // the CLI commands may use.
                require_once( $this->plugin->folder . 'includes/admin/common.php' );
                require_once( $this->plugin->folder . 'includes/admin/generate.php' );
                require_once( $this->plugin->folder . 'includes/admin/geo.php' );
                require_once( $this->plugin->folder . 'includes/admin/groups.php' );
                require_once( $this->plugin->folder . 'includes/admin/groups-terms.php' );
                require_once( $this->plugin->folder . 'includes/admin/import.php' );
                require_once( $this->plugin->folder . 'includes/admin/keywords.php' );
                require_once( $this->plugin->folder . 'includes/admin/spintax.php' );
                require_once( $this->plugin->folder . 'includes/admin/youtube.php' );

                // Load the CLI command(s)
                require_once( $this->plugin->folder . 'includes/admin/cli.php' );
            }
        }

    }

    /**
     * Detects if the Free version of the Plugin is running, and if so,
     * deactivates it.
     *
     * @since   1.6.7
     */
    public function deactivate_free_version() {
        
        // Bail if the function is not available
        if ( ! function_exists( 'deactivate_plugins' ) ) {
            return;
        }

        // Bail if the Free version is not active
        if ( ! is_plugin_active( 'page-generator/page-generator.php' ) ) {
            return;
        }

        // Deactivate the Free version
        deactivate_plugins( 'page-generator/page-generator.php' );
      
    }

    /**
     * Runs the upgrade routine once the plugin has loaded
     *
     * @since   1.1.7
     */
    public function upgrade() {

        // Run upgrade routine
        Page_Generator_Pro_Install::get_instance()->upgrade();

    }

    /**
     * Returns the singleton instance of the class.
     *
     * @since 1.1.6
     *
     * @return object Class.
     */
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

}

// Initialise class
$page_generator_pro = Page_Generator_Pro::get_instance();

// Register activation hooks
register_activation_hook( __FILE__, array( 'Page_Generator_Pro_Install', 'activate' ) );
add_action( 'activate_wpmu_site', array( 'Page_Generator_Pro_Install', 'activate_wpmu_site' ) );