<?php
/**
 * Taxonomies class
 * 
 * @package  Page Generator Pro
 * @author   Tim Carr
 * @version  1.6.1
 */
class Page_Generator_Pro_Taxonomy {

    /**
     * Holds the class object.
     *
     * @since   1.6.1
     *
     * @var     object
     */
    public static $instance;

    /**
     * Holds the Taxonomy Name for Taxonomy Groups
     *
     * @since   1.6.1
     *
     * @var     string
     */
    public $taxonomy_name = 'page-generator-tax';

    /**
     * Constructor
     *
     * @since   1.6.1
     */
    public function __construct() {

        // Register post types
        add_action( 'init', array( $this, 'register_taxonomies' ) );
        
    }

    /**
     * Registers Custom Post Types
     *
     * @since    1.6.1
     */
    public function register_taxonomies() {

        register_taxonomy( $this->taxonomy_name, array( Page_Generator_Pro_PostType::get_instance()->post_type_name ), array(
            'labels'            => array(
                'name'                  => _x( 'Taxonomy Groups', 'Taxonomy Groups', 'page-generator-pro' ),
                'singular_name'         => _x( 'Taxonomy Group', 'Taxonomy Group', 'page-generator-pro' ),
                'search_items'          => __( 'Search Taxonomy Groups', 'page-generator-pro' ),
                'popular_items'         => __( 'Popular Taxonomy Groups', 'page-generator-pro' ),
                'all_items'             => __( 'All Taxonomy Groups', 'page-generator-pro' ),
                'parent_item'           => __( 'Parent Taxonomy Group', 'page-generator-pro' ),
                'parent_item_colon'     => __( 'Parent Taxonomy Group', 'page-generator-pro' ),
                'edit_item'             => __( 'Edit Taxonomy Group', 'page-generator-pro' ),
                'update_item'           => __( 'Update Taxonomy Group', 'page-generator-pro' ),
                'add_new_item'          => __( 'Add New Taxonomy Group', 'page-generator-pro' ),
                'new_item_name'         => __( 'New Taxonomy Group Name', 'page-generator-pro' ),
                'add_or_remove_items'   => __( 'Add or remove Taxonomy Groups', 'page-generator-pro' ),
                'choose_from_most_used' => __( 'Choose from most used Taxonomy Groups', 'page-generator-pro' ),
                'menu_name'             => __( 'Taxonomy Group', 'page-generator-pro' ),
            ),
            'public'            => false,
            'publicly_queryable'=> false,
            'show_ui'           => true,
            'show_in_menu'      => true,
            'show_in_nav_menus' => false,
            'show_in_rest'      => false,
            'show_tagcloud'     => false,
            'show_in_quick_edit'=> false,
            'show_admin_column' => false,
            'hierarchical'      => false,
        ) );

    }

    /**
     * Returns the singleton instance of the class.
     *
     * @since   1.6.1
     *
     * @return  object Class.
     */
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

}

// Load the class
$page_generator_pro_taxonomy = Page_Generator_Pro_Taxonomy::get_instance();