<?php
/**
 * Editor class
 * 
 * @package Page_Generator_Pro
 * @author  Tim Carr
 * @version 1.0.0
 */
class Page_Generator_Pro_Editor {

    /**
     * Holds the class object.
     *
     * @since 1.1.3
     *
     * @var object
     */
    public static $instance;

    /**
     * Holds the base object.
     *
     * @since 1.2.1
     *
     * @var object
     */
    public $base;

    /**
     * Constructor
     *
     * @since 1.0.0
     */
    public function __construct() {

        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'admin_init', array( $this, 'setup_tinymce_plugins' ) );

    }

    /**
     * Enqueues the Modal and QuickTags script for the Text Editor
     *
     * @since   1.5.2
     */
    public function enqueue_scripts() {

        // Get base instance
        $this->base = Page_Generator_Pro::get_instance();

        // modal.js
        wp_enqueue_script( 'wpzinc-admin-modal' );

    }

    /**
     * Setup calls to add a button and plugin to the Page Generator Pro WP_Editor
     *
     * @since 1.0.0
     */
    public function setup_tinymce_plugins() {

		// Check if rich editing is enabled for the user
        if ( get_user_option( 'rich_editing' ) != 'true' ) {
        	return;
        }

        // Add filters to register TinyMCE Plugins
		add_filter( 'mce_external_plugins', array( $this, 'register_tinymce_plugins' ) );
        add_filter( 'mce_buttons', array( $this, 'register_tinymce_buttons' ) );

    }

    /**
     * Register JS plugins for the TinyMCE Editor
     *
     * @since   1.0.0
     *
     * @param   array   $plugins    JS Plugins
     * @return  array 		        JS Plugins
     */
    public function register_tinymce_plugins( $plugins ) {

        // Get base instance
        $this->base = Page_Generator_Pro::get_instance();

        // Check we are on the Groups screen
        $screen = get_current_screen();
        if ( $screen->post_type != $this->base->plugin->name ) {
            return $plugins;
        }

        // Register TinyMCE Plugins
    	$plugins['page_generator_pro_google_maps']     = $this->base->plugin->url . 'assets/js/min/tinymce-google-map-min.js';
        $plugins['page_generator_pro_related_links']   = $this->base->plugin->url . 'assets/js/min/tinymce-related-links-min.js';
	    $plugins['page_generator_pro_wikipedia']       = $this->base->plugin->url . 'assets/js/min/tinymce-wikipedia-min.js';
	    $plugins['page_generator_pro_yelp']            = $this->base->plugin->url . 'assets/js/min/tinymce-yelp-min.js';
	    $plugins['page_generator_pro_youtube']         = $this->base->plugin->url . 'assets/js/min/tinymce-youtube-min.js';

	    return $plugins;

    }

    /**
     * Registers buttons in the TinyMCE Editor
     *
     * @since   1.0.0
     *
     * @param   array   $buttons    Buttons
     * @return  array 		        Buttons
     */
    public function register_tinymce_buttons( $buttons ) {

        // Get base instance
        $this->base = Page_Generator_Pro::get_instance();

        // Check we are on the Groups screen
        $screen = get_current_screen();
        if ( $screen->post_type != $this->base->plugin->name ) {
            return $buttons;
        }

    	array_push( 
            $buttons,
            'page_generator_pro_google_maps', 
            'page_generator_pro_wikipedia', 
            'page_generator_pro_yelp', 
            'page_generator_pro_youtube',
            'page_generator_pro_related_links'
        );
    	return $buttons;

    }

    /**
     * Returns the singleton instance of the class.
     *
     * @since 1.1.3
     *
     * @return object Class.
     */
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

}

// Load the class
$page_generator_pro_editor = Page_Generator_Pro_Editor::get_instance();