<?php
/**
 * Spintax class
 * 
 * @package Page_Generator_Pro
 * @author  Tim Carr
 * @version 1.0.0
 */
class Page_Generator_Pro_Spintax {

    /**
     * Holds the class object.
     *
     * @since   1.0.0
     *
     * @var     object
     */
    public static $instance;

    /**
     * Searches for spintax, replacing each spintax with one term
     *
     * @since   1.0.0
     *
     * @param   string  $text   Text
     * @return  string          Text
     */
    public function process( $text ) {

        return preg_replace_callback(
            '/\{(((?>[^\{\}]+)|(?R))*)\}/x',
            array( $this, 'replace' ),
            $text
        );
        
    }

    /**
     * Replaces spintax with text
     *
     * @since   1.0.0
     *
     * @param   string  $text   Text
     * @return  string          Text
     */
    public function replace( $text ) {

        // Process
        $processed_text = $this->process( $text[1] );

        // If no pipe delimiter exists, this isn't spintax
        // It might be CSS or JSON, so we need to return the original string with the curly braces
        if ( strpos( $processed_text, '|' ) === false ) {
            return '{' . $processed_text . '}';
        }

        // Explode the spintax options and return a random array value
        $parts = explode( '|', $processed_text );
        return $parts[ array_rand( $parts ) ];

    }

    /**
     * Returns the singleton instance of the class.
     *
     * @since 1.0.0
     *
     * @return object Class.
     */
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

}