jQuery( document ).ready( function( $ ) {
	// Map
    if ( $( 'div.page-generator-pro-map' ).length > 0) {
    	$( 'div.page-generator-pro-map' ).each( function() {
    		var mapElement = $(this);
			google.maps.event.addDomListener(window, 'load', function() {
				var latLng = new google.maps.LatLng($(mapElement).data('lat'), $(mapElement).data('lng'));
				
				// Map
				var map = new google.maps.Map($(mapElement)[0], {
			  		zoom: $(mapElement).data('zoom'),
			    	center: latLng,
			    	mapTypeId: google.maps.MapTypeId.ROADMAP
			  	});
			  	
			  	// Info Window
			  	var infoWindow = new google.maps.InfoWindow({
			  		content: $(mapElement).data('address')
			  	});
			  	
			  	// Marker
			  	var marker = new google.maps.Marker({
				    position: latLng,
				    map: map,
				    title: $(mapElement).data('address')
				});
				
				// Marker Click
				google.maps.event.addListener(marker, 'click', function() {
					infoWindow.open(map,marker);
				});
			});
    	});
	}
});