jQuery( document ).ready(function( $ ) {

	/**
	 * Selectize
	 */
	$( 'select.wpzinc-selectize' ).selectize( {
		plugins: ['drag_drop'],
	    delimiter: ',',
	    persist: false,
	    create: function( input ) {
	        return {
	            value: input,
	            text: input
	        }
	    }
	} );

	/**
	* Generate: Custom Fields: Add
	*/
	$( 'a.add-custom-field' ).click( function( e ) {
		
		e.preventDefault();
		
		// Copy hidden element
		var element = $( 'div.hidden', $( this ).parent().parent().parent() );
		$( '#custom-fields' ).append( '<div class="option">' + $( element ).html() + '</div>' );

	} );

	/**
	 * Generate: Custom Fields: Delete
	 */
	$( document ).on( 'click', 'a.delete-custom-field', function( e ) {
		
		e.preventDefault();
		
		// Delete row
		$( this ).closest( 'div.option' ).remove();

	} );

	/**
	* Generate: Custom Fields: Sort
	*/
	if ( $( '#custom-fields' ).length > 0) {
		$( '#custom-fields' ).sortable();
	}

	/**
	 * Generate: Deselect All Taxonomy Terms
	 */
	$( document ).on( 'click', 'a.deselect-all', function( e ) {

		e.preventDefault();

		$( 'input[type="checkbox"]', $( $( this ).data( 'list' ) ) ).prop( 'checked', false );

	} );

	/**
	 * Generate: Post Type Toggle
	 */
	$( 'select[name="page-generator-pro[type]"]' ).on( 'change.page-generator-pro', function( e ) {
		
		var post_type = $( this ).val();

		// Hide attributes and taxonomies
		$( '#page-generator-pro-attributes div.option' ).hide();
		$( '#page-generator-pro-taxonomies div.option' ).hide();

		// Show templates, parent page dropdowns and taxonomies matching the chosen post type
		$( '#page-generator-pro-attributes div.option.' + post_type ).show();
		$( '#page-generator-pro-taxonomies div.option.' + post_type ).show();
		
	} );
	$( 'select[name="page-generator-pro[type]"]' ).trigger( 'change.page-generator-pro' );

	/**
	 * Generate: Status
	 */
	$( 'select[name="page-generator-pro[status]"]' ).on( 'change.page-generator-pro', function( e ) {
		var status = $( this ).val();
		
		// Hide options
		$( 'div.future' ).hide();

		// Show options matching the chosen post type
		$( 'div.' + status ).show();
	} );
	$( 'select[name="page-generator-pro[status]"]' ).trigger( 'change.page-generator-pro' );

	/**
	 * Generate: Date
	 */
	$( 'select[name="page-generator-pro[date_option]"]' ).on( 'change.page-generator-pro', function( e ) {
		var status = $( this ).val();

		// Hide options
		$( 'div.specific' ).hide();
		$( 'div.random' ).hide();
		
		// Show options matching the chosen date option
		$( 'div.' + status ).show();
	} );
	$( 'select[name="page-generator-pro[date_option]"]' ).trigger( 'change.page-generator-pro' );

	/**
	 * Generate: Featured Image
	 */
	$( 'select[name="page-generator-pro[featured_image_source]"]' ).on( 'change.page-generator-pro', function( e ) {

		var source = $( this ).val();

		// Hide Featured Image options
		$( 'div.featured_image' ).hide();

		// Depending on the Featured Image source, display some options
		switch ( source ) {
			case 'id':
				$( 'div.featured_image.value' ).show();
				break;

			case 'url':
				$( 'div.featured_image.value' ).show();
				$( 'div.featured_image.url' ).show();
				break;
		}

	} );
	$( 'select[name="page-generator-pro[featured_image_source]"]' ).trigger( 'change.page-generator-pro' );

	/**
	 * Groups: Submit
	 */
	$( 'body.post-type-page-generator-pro form input[type=submit]' ).click( function( e ) {

		// Prevent WordPress from throwing a dialog warning that changes will be lost
		$( window ).off( 'beforeunload.edit-post' );

		var action = $( this ).attr( 'name' );
		switch ( action ) {

			/**
			 * Test
			 */
			case 'test':
				var result = confirm( 'This will save your settings and generate a single Page/Post in draft mode. Proceed?' );
				if ( ! result) {
					e.preventDefault();
					return false;
				}
				break;

			/**
			 * Generate
			 */
			case 'generate':
				var result = confirm( 'This will save your settings and generate Pages/Posts. Proceed?' );
				if ( ! result) {
					e.preventDefault();
					return false;
				}
				break;

			/**
			 * Delete
			 */
			case 'delete':
				var result = confirm( 'This will delete ALL content generated by this group. Proceed?' );
				if ( ! result) {
					e.preventDefault();
					return false;
				}
				break;
		}

	} );

	/**
	 * Generate Terms: Submit
	 */
	$( 'body.taxonomy-page-generator-tax form input[type=submit]' ).click( function( e ) {

		// Prevent WordPress from throwing a dialog warning that changes will be lost
		$( window ).off( 'beforeunload.edit-post' );

		var action = $( this ).attr( 'name' );
		switch ( action ) {

			/**
			 * Test
			 */
			case 'test':
				var result = confirm( 'This will save your settings and generate a single Term. Proceed?' );
				if ( ! result) {
					e.preventDefault();
					return false;
				}
				break;

			/**
			 * Generate
			 */
			case 'generate':
				var result = confirm( 'This will save your settings and generate Terms. Proceed?' );
				if ( ! result) {
					e.preventDefault();
					return false;
				}
				break;

			/**
			 * Save
			 */
			case 'save':
				// Nothing to do
				break;	
		}

	} );

} );